#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define N 20

struct vozilo
{
	int id;
	int tip; 
	// 0 - auto, 1 - autobus, 2 - kamion
	
};

int smer = 0;
// 0 - neodredjen
// 1 - sever
// 2 - jug

int nAutomobila = 0, nAutobusa = 0, nKamiona = 0;
int cekajuSever = 0, cekajuJug = 0;

pthread_mutex_t mutex;
pthread_cond_t condSmer;
pthread_cond_t condVozilo;


void *severnoVozilo(void *arg)
{
	struct vozilo *v = arg;
	
	cekajuSever++;
	
	switch (v->tip)
	{
		case 0:
			sleep(rand() % 3 + 1);
			printf("Sever: Automobil %d ceka da predje nadvoznjak.\n", v->id);
			
			pthread_mutex_lock(&mutex);
			
			while (smer == 2) // ceka sve dok prolaze vozila sa juga
				pthread_cond_wait(&condSmer, &mutex);
			
			smer = 1;
			
			while (nKamiona > 0) // zatim ceka ako ima kamiona iz svog smera
				pthread_cond_wait(&condVozilo, &mutex);
			
			cekajuSever--;
			nAutomobila++;
			
			pthread_mutex_unlock(&mutex);
			
			printf("Sever: Automobil %d prelazi nadvoznjak.\n", v->id);

			sleep(rand() % 3 + 1);
			
			pthread_mutex_lock(&mutex);

			nAutomobila--;
			
			if (cekajuSever == 0) // obavesti vozila iz drugog smera da nema vise vozila
			{		
				smer = 0;
				pthread_cond_broadcast(&condSmer);	
			}
			else if (nAutomobila == 0) // obavestava ostala vozila iz svog smera da nema automobila
			{
				pthread_cond_broadcast(&condVozilo);
			}	

			pthread_mutex_unlock(&mutex);

			break;
			
		case 1:
			sleep(rand() % 3 + 1);
			printf("Sever: Autobus %d ceka da predje nadvoznjak.\n", v->id);
			
			pthread_mutex_lock(&mutex);
			
			while (smer == 2) // ceka sve dok prolaze vozila sa juga
				pthread_cond_wait(&condSmer, &mutex);
			
			smer = 1;
			
			while (nKamiona > 0 || nAutobusa > 0) // zatim ceka ako ima kamiona ili drugih autobusa iz svog smera
				pthread_cond_wait(&condVozilo, &mutex);
			
			cekajuSever--;
			nAutobusa++;
			
			pthread_mutex_unlock(&mutex);
			
			
			printf("Sever: Autobus %d prelazi nadvoznjak.\n", v->id);

			sleep(rand() % 3 + 1);
			
			pthread_mutex_lock(&mutex);

			nAutobusa--;

			if (cekajuSever == 0) // obavesti vozila iz drugog smera da nema vise vozila
			{		
				smer = 0;
				pthread_cond_broadcast(&condSmer);	
			}
			else if (nAutobusa == 0) // obavestava ostala vozila iz svog smera da nema autobusa
			{
				pthread_cond_broadcast(&condVozilo);
			}	
				
			pthread_mutex_unlock(&mutex);
			
			break;
			
		default:
			sleep(rand() % 3 + 1);
			printf("Sever: Kamion %d ceka da predje nadvoznjak.\n", v->id);
			
			pthread_mutex_lock(&mutex);
			
			while (smer == 2) // ceka sve dok prolaze vozila sa juga
				pthread_cond_wait(&condSmer, &mutex);
			
			smer = 1;
			
			while (nKamiona > 0 || nAutobusa > 0 || nKamiona > 0) // zatim ceka ako ima bilo koje vozilo iz svog smera
				pthread_cond_wait(&condVozilo, &mutex);
			
			cekajuSever--;
			nKamiona++;

			pthread_mutex_unlock(&mutex);
			
			printf("Sever: Kamion %d prelazi nadvoznjak.\n", v->id);
			
			sleep(rand() % 3 + 1);
			
			pthread_mutex_lock(&mutex);

			nKamiona--;
			
			if (cekajuSever == 0) // obavesti vozila iz drugog smera da nema vise vozila
			{		
				smer = 0;
				pthread_cond_broadcast(&condSmer);	
			}
			else if (nKamiona == 0) // obavestava ostala vozila iz svog smera da nema kamiona
			{
				pthread_cond_broadcast(&condVozilo);
			}	
				
			pthread_mutex_unlock(&mutex);
			
			break;
	}
}

void *juznoVozilo(void *arg)
{
	struct vozilo *v = arg;
	
	cekajuJug++;
	
	switch (v->tip)
	{
		case 0:
			sleep(rand() % 3 + 1);
			printf("Jug: Automobil %d ceka da predje nadvoznjak.\n", v->id);
			
			pthread_mutex_lock(&mutex);
			
			while (smer == 1) // ceka sve dok prolaze vozila sa juga
				pthread_cond_wait(&condSmer, &mutex);
			
			smer = 2;
			
			while (nKamiona > 0) // zatim ceka ako ima kamiona iz svog smera
				pthread_cond_wait(&condVozilo, &mutex);
			
			cekajuJug--;
			nAutomobila++;
			
			pthread_mutex_unlock(&mutex);
			
			printf("Jug: Automobil %d prelazi nadvoznjak.\n", v->id);

			sleep(rand() % 3 + 1);
			
			pthread_mutex_lock(&mutex);

			nAutomobila--;
			
			if (cekajuJug == 0) // obavesti vozila iz drugog smera da nema vise vozila
			{		
				smer = 0;
				pthread_cond_broadcast(&condSmer);	
			}
			else if (nAutomobila == 0) // obavestava ostala vozila iz svog smera da nema automobila
			{
				pthread_cond_broadcast(&condVozilo);
			}	

			pthread_mutex_unlock(&mutex);

			break;
			
		case 1:
			sleep(rand() % 3 + 1);
			printf("Jug: Autobus %d ceka da predje nadvoznjak.\n", v->id);
			
			pthread_mutex_lock(&mutex);
			
			while (smer == 1) // ceka sve dok prolaze vozila sa juga
				pthread_cond_wait(&condSmer, &mutex);
			
			smer = 2;
			
			while (nKamiona > 0 || nAutobusa > 0) // zatim ceka ako ima kamiona ili drugih autobusa iz svog smera
				pthread_cond_wait(&condVozilo, &mutex);
			
			cekajuJug--;
			nAutobusa++;
			
			pthread_mutex_unlock(&mutex);
			
			printf("Jug: Autobus %d prelazi nadvoznjak.\n", v->id);

			sleep(rand() % 3 + 1);
			
			pthread_mutex_lock(&mutex);

			nAutobusa--;
			
			if (cekajuJug == 0) // obavesti vozila iz drugog smera da nema vise vozila
			{		
				smer = 0;
				pthread_cond_broadcast(&condSmer);	
			}
			else if (nAutobusa == 0) // obavestava ostala vozila iz svog smera da nema autobusa
			{
				pthread_cond_broadcast(&condVozilo);
			}	
				
			pthread_mutex_unlock(&mutex);
			
			break;
			
		default:
			sleep(rand() % 3 + 1);
			printf("Jug: Kamion %d ceka da predje nadvoznjak.\n", v->id);
			
			pthread_mutex_lock(&mutex);
			
			while (smer == 1) // ceka sve dok prolaze vozila sa juga
				pthread_cond_wait(&condSmer, &mutex);
			
			smer = 2;
			
			while (nKamiona > 0 || nAutobusa > 0 || nKamiona > 0) // zatim ceka ako ima bilo koje vozilo iz svog smera
				pthread_cond_wait(&condVozilo, &mutex);
			
			cekajuJug--;
			nKamiona++;

			pthread_mutex_unlock(&mutex);
			
			printf("Jug: Kamion %d prelazi nadvoznjak.\n", v->id);
			
			sleep(rand() % 3 + 1);
			
			pthread_mutex_lock(&mutex);

			nKamiona--;
			
			if (cekajuJug == 0) // obavesti vozila iz drugog smera da nema vise vozila
			{		
				smer = 0;
				pthread_cond_broadcast(&condSmer);	
			}
			else if (nKamiona == 0) // // obavestava ostala vozila iz svog smera da nema kamiona
			{
				pthread_cond_broadcast(&condVozilo);
			}	
				
			pthread_mutex_unlock(&mutex);
			
			break;
	}
}


int main()
{
	pthread_mutex_init(&mutex, NULL);
	pthread_cond_init(&condSmer, NULL);
	pthread_cond_init(&condVozilo, NULL);
	
	pthread_t vozilaThreads[N];
	
	long i;
	
	struct vozilo vozila[N];
	
	for (i = 0; i < N; i++) 
	{
		vozila[i].id = i;
		vozila[i].tip = rand() % 3;
		
		if (i % 2 == 0) pthread_create(vozilaThreads + i, NULL, &severnoVozilo, &vozila[i]);
		else pthread_create(vozilaThreads + i, NULL, &juznoVozilo, &vozila[i]);
	}
	
	for (i = 0; i < N; i++) 
		pthread_join(vozilaThreads[i], NULL);
	
	return 0;
}
